<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_type');
			$table->string('username');
			$table->string('password');
			$table->string('email');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('phone');
			$table->string('line_id');
			$table->string('work_space');
			$table->string('id_card');
			$table->enum('gender', array('m', 'f'));
			$table->date('birthdate');
			$table->string('religion');
			$table->string('race');
			$table->string('nationality');
			$table->string('size_shirt');
			$table->string('size_plant');
			$table->string('disease');
			$table->string('education');
			$table->string('address');
			$table->integer('english_talk');
			$table->integer('english_read');
			$table->integer('english_listen');
			$table->string('file_photo');
			$table->string('file_card');
			$table->string('file_certificate');
			$table->string('file_profile');
			$table->string('file_medical');
			$table->string('file_guaranty');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}