<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerOwnersTable extends Migration {

	public function up()
	{
		Schema::create('player_owners', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('player_id')->unsigned();
			$table->date('start_date');
			$table->date('finish_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('player_owners');
	}
}