<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('papers', function(Blueprint $table) {
			$table->foreign('journal_id')->references('id')->on('journals')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_keyword_look_up', function(Blueprint $table) {
			$table->foreign('paper_id')->references('id')->on('papers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_keyword_look_up', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_author_look_up', function(Blueprint $table) {
			$table->foreign('paper_id')->references('id')->on('papers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_author_look_up', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('authors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('technical_high_levels', function(Blueprint $table) {
			$table->foreign('technical_area_id')->references('id')->on('technical_areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('technical_low_levels', function(Blueprint $table) {
			$table->foreign('technical_high_level_id')->references('id')->on('technical_high_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_technical_low_levels_look_up', function(Blueprint $table) {
			$table->foreign('paper_id')->references('id')->on('papers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paper_technical_low_levels_look_up', function(Blueprint $table) {
			$table->foreign('tech_low_level_id')->references('id')->on('technical_low_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('low_level_attributes', function(Blueprint $table) {
			$table->foreign('paper_id')->references('id')->on('papers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('low_level_attributes', function(Blueprint $table) {
			$table->foreign('technical_low_level_id')->references('id')->on('technical_low_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attributes_value', function(Blueprint $table) {
			$table->foreign('technical_low_level_id')->references('id')->on('technical_low_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('papers', function(Blueprint $table) {
			$table->dropForeign('papers_journal_id_foreign');
		});
		Schema::table('paper_keyword_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_keyword_look_up_paper_id_foreign');
		});
		Schema::table('paper_keyword_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_keyword_look_up_keyword_id_foreign');
		});
		Schema::table('paper_author_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_author_look_up_paper_id_foreign');
		});
		Schema::table('paper_author_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_author_look_up_author_id_foreign');
		});
		Schema::table('technical_high_levels', function(Blueprint $table) {
			$table->dropForeign('technical_high_levels_technical_area_id_foreign');
		});
		Schema::table('technical_low_levels', function(Blueprint $table) {
			$table->dropForeign('technical_low_levels_technical_high_level_id_foreign');
		});
		Schema::table('paper_technical_low_levels_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_technical_low_levels_look_up_paper_id_foreign');
		});
		Schema::table('paper_technical_low_levels_look_up', function(Blueprint $table) {
			$table->dropForeign('paper_technical_low_levels_look_up_tech_low_level_id_foreign');
		});
		Schema::table('low_level_attributes', function(Blueprint $table) {
			$table->dropForeign('low_level_attributes_paper_id_foreign');
		});
		Schema::table('low_level_attributes', function(Blueprint $table) {
			$table->dropForeign('low_level_attributes_technical_low_level_id_foreign');
		});
		Schema::table('attributes_value', function(Blueprint $table) {
			$table->dropForeign('attributes_value_technical_low_level_id_foreign');
		});
	}
}