<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DebtBilling extends Eloquent {

	protected $table = 'debt_billing';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function debts()
	{
		return $this->hasOne('Debts', 'id_debt');
	}

	public function customer()
	{
		return $this->hasOne('Customers', 'id_customer');
	}

	public function tenant()
	{
		return $this->hasOne('Tenant', 'id_tenant');
	}

}