<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id_supplier');
			$table->integer('id_tenant')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('supplier_name', 25)->unique();
			$table->string('supplier_phone', 20);
			$table->string('supplier_address', 100);
			$table->text('supplier_info');
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}