<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseOrder extends Model 
{

    protected $table = 'purchase_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function supplier()
    {
        return $this->hasOne('Suppliers', 'id_supplier');
    }

    public function poItems()
    {
        return $this->hasMany('PoItems', 'id_poitems');
    }

    public function paymentType()
    {
        return $this->hasOne('PaymentTypes', 'id_paytype');
    }

    public function tenant()
    {
        return $this->hasOne('Tenant', 'id_tenant');
    }

}