<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agent extends Eloquent {

	protected $table = 'agents';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('firstName', 'lastName', 'matricule', 'email');

	public function qrcode()
	{
		return $this->hasOne('QrCode', 'qrcode_id');
	}

}