<?php

namespace userquiz;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserQuiz extends Model 
{

    protected $table = 'user_quiz';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('User');
    }

    public function quiz()
    {
        return $this->hasMany('Quiz');
    }

}