<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizResultsTable extends Migration {

	public function up()
	{
		Schema::create('quiz_results', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('quiz_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('quiz_status', array('pass', 'fail'));
			$table->integer('marks_obtained')->nullable();
			$table->integer('number_of_correct_answers');
			$table->integer('number_of_attempted_questions')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quiz_results');
	}
}