<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTable extends Migration {

	public function up()
	{
		Schema::create('payment', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('shipping_profile_id')->unsigned()->nullable();
			$table->integer('billing_profile_id')->unsigned();
			$table->string('items');
			$table->string('amount');
			$table->string('discount_code')->nullable()->default('NULL');
			$table->string('discount_percent')->nullable()->default('NULL');
			$table->string('giftcard_code')->nullable()->default('NULL');
			$table->integer('giftcard_amount')->nullable()->default('NULL');
			$table->string('currency');
			$table->string('method');
			$table->string('status_code');
			$table->string('status');
			$table->string('processor');
			$table->text('returnData');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment');
	}
}