<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillingProfileTable extends Migration {

	public function up()
	{
		Schema::create('billing_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->nullable()->default('NULL');
			$table->string('country');
			$table->string('firstname');
			$table->string('lastname');
			$table->string('company')->nullable()->default('NULL');
			$table->string('companyId')->nullable()->default('NULL');
			$table->string('address');
			$table->integer('lang_id');
			$table->string('address_additional')->nullable()->default('NULL');
			$table->string('city');
			$table->string('email');
			$table->string('phone');
			$table->string('zip');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('billing_profile');
	}
}