<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email');
			$table->string('password');
			$table->tinyInteger('is_artist');
			$table->tinyInteger('is_admin');
			$table->tinyInteger('confirmed');
			$table->string('confirmation_code')->nullable()->default('NULL');
			$table->string('fb_id');
			$table->string('remember_token', 100)->nullable()->default('NULL');
			$table->timestamp('updated_at')->nullable();
			$table->timestamp('created_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}