<?php

namespace product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('model', 'sku', 'upc', 'ean', 'jan', 'isbn', 'mpn', 'location', 'quantity', 'minimum', 'subtract', 'stock_status_id', 'shipping', 'date_available', 'length', 'width', 'height', 'lenght_class_id', 'weight', 'weight_class_id', 'status', 'sort_order', 'manufacturer_id', 'image', 'price', 'points', 'tax_class_id', 'viewed');

    public function description()
    {
        return $this->hasOne('Product_description')->withDefault();
    }

    public function discount()
    {
        return $this->hasOne('Product_discount')->withDefault();
    }

    public function image()
    {
        return $this->hasMany('Product_image')->withDefault();
    }

    public function categories()
    {
        return $this->belongsToMany('Category', 'product_category');
    }

}