<?php

namespace category_description;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category_description extends Model 
{

    protected $table = 'category_description';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('language_id', 'name', 'description', 'meta_title', 'meta_description', 'meta_keyword');

    public function category()
    {
        return $this->belongsTo('Category');
    }

}