<?php

namespace product_discount;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product_discount extends Eloquent {

	protected $table = 'product_discount';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'customer_group_id', 'quantity', 'priority', 'price', 'date_start', 'date_end');

	public function product()
	{
		return $this->belongsTo('Product');
	}

}