<?php

namespace category;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image', 'parent_id', 'top', 'column', 'status', 'sort_order');

	public function description()
	{
		return $this->hasOne('Category_description')->withDefault();
	}

	public function products()
	{
		return $this->belongsToMany('Product', 'product_category');
	}

}