<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaxRateTable extends Migration {

	public function up()
	{
		Schema::create('tax_rate', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 32);
			$table->decimal('rate', 15,4)->default('0.0000');
			$table->string('type', 1);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tax_rate');
	}
}