<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionValueTable extends Migration {

	public function up()
	{
		Schema::create('product_option_value', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_option_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('option_id')->unsigned();
			$table->bigInteger('option_value_id')->unsigned();
			$table->smallInteger('quantity');
			$table->tinyInteger('subtract');
			$table->decimal('price', 15,4);
			$table->string('price_prefix', 1);
			$table->decimal('weight', 15,4);
			$table->string('weight_prefix', 1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_option_value');
	}
}