<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image', 255)->nullable()->default('NULL');
			$table->bigInteger('parent_id')->index()->default('0');
			$table->tinyInteger('top');
			$table->smallInteger('column');
			$table->tinyInteger('status');
			$table->smallInteger('sort_order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}