<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobTitleTable extends Migration {

	public function up()
	{
		Schema::create('job_title', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('title', 255)->nullable();
			$table->integer('category_id')->nullable();
			$table->string('description', 255)->nullable();
			$table->text('image')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->integer('created_by')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('job_title');
	}
}