<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceCategory extends Model 
{

    protected $table = 'service_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'image', 'is_active', 'created_by');

    public function jobTitle()
    {
        return $this->hasMany('JobTitle', 'category_id', 'id');
    }

}