<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_staff', 'from_client', 'from_admin', 'to_staff', 'to_client', 'notification_type', 'is_active');

	public function notificationType()
	{
		return $this->hasOne('NotificationCategories', 'id', 'notification_type');
	}

}