<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationTable extends Migration {

	public function up()
	{
		Schema::create('location', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('franchise_id')->unsigned()->nullable();
			$table->text('name')->nullable();
			$table->text('slug')->nullable();
			$table->text('is_active')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('location');
	}
}