<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffAvailabilityTable extends Migration {

	public function up()
	{
		Schema::create('staff_availability', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('staff_id')->unsigned()->nullable();
			$table->date('date')->nullable();
			$table->tinyInteger('am')->nullable();
			$table->integer('pm')->nullable();
			$table->tinyInteger('nd');
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('staff_availability');
	}
}