<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientManagerTable extends Migration {

	public function up()
	{
		Schema::create('client_manager', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('phone_number')->nullable();
			$table->string('alt_phone_number', 255)->nullable();
			$table->string('company_name')->nullable();
			$table->text('company_logo')->nullable();
			$table->string('street_number', 255)->nullable();
			$table->string('street_name', 255)->nullable();
			$table->string('sub_urban', 255)->nullable();
			$table->integer('location_id')->nullable();
			$table->integer('state_id')->nullable();
			$table->integer('franchise_id')->nullable();
			$table->tinyInteger('is_approved')->nullable()->default('0');
			$table->tinyInteger('is_active')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('client_manager');
	}
}