<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('email');
			$table->timestamp('email_verified_at')->nullable();
			$table->text('password');
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('mobile');
			$table->enum('type', array('admin', 'provider', 'marketer'));
			$table->enum('provider_type', array('x', 'y', 'z'));
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('address');
			$table->date('birth_date')->nullable();
			$table->enum('status', array('pending', 'approved', 'canceled'));
			$table->integer('years_of_experience')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}