<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('rallies', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rally_user', function(Blueprint $table) {
			$table->foreign('rally_id')->references('id')->on('rallies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rally_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('owner_rally', function(Blueprint $table) {
			$table->foreign('rally_id')->references('id')->on('rallies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('owner_rally', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('rallies', function(Blueprint $table) {
			$table->dropForeign('rallies_campaign_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('rally_user', function(Blueprint $table) {
			$table->dropForeign('rally_user_rally_id_foreign');
		});
		Schema::table('rally_user', function(Blueprint $table) {
			$table->dropForeign('rally_user_user_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_owner_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_user_id_foreign');
		});
		Schema::table('owner_rally', function(Blueprint $table) {
			$table->dropForeign('owner_rally_rally_id_foreign');
		});
		Schema::table('owner_rally', function(Blueprint $table) {
			$table->dropForeign('owner_rally_user_id_foreign');
		});
	}
}