<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Campaign extends Model 
{

    protected $table = 'campaigns';
    public $timestamps = true;

    public function campaignOwner()
    {
        return $this->belongsTo('User', 'owner_id');
    }

    public function followers()
    {
        return $this->belongsToMany('User', 'campaign_user', 'campaign_id', 'user_id');
    }

    public function ralliesPerCategory()
    {
        return $this->hasMany('Rally');
    }

    public function TransactionsPerCampaign()
    {
        return $this->hasManyThrough('Rally', 'Transaction');
    }

}