<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('car_type_id')->references('id')->on('car_type')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('mark_id')->references('id')->on('marks')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('years', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('car_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->foreign('reason_id')->references('id')->on('reasons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('car_type_id')->references('id')->on('car_type')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('cancel_reason_id')->references('id')->on('reasons')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_car_type_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_car_model_id_foreign');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->dropForeign('tokens_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_driver_id_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_mark_id_foreign');
		});
		Schema::table('years', function(Blueprint $table) {
			$table->dropForeign('years_model_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_receiver_id_foreign');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->dropForeign('complaints_reason_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_user_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_driver_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_car_type_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_payment_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_cancel_reason_id_foreign');
		});
	}
}