<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 191)->nullable();
			$table->string('price', 191)->nullable();
			$table->enum('type', array('offer', 'charge'))->nullable();
			$table->date('end_date')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}