<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function stocks()
	{
		return $this->belongsToMany('App\Models\Stock');
	}

}