<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Providers extends Model 
{

    protected $table = 'providers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'service_id', 'email', 'reposible_name', 'phone_num', 'description', 'user_id');

    public function service()
    {
        return $this->belongsTo('Services', 'service_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}