<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Activation extends Model 
{

    protected $table = 'activations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('phone_num', 'code', 'user_id');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}