<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Factory extends Eloquent {

	protected $table = 'factory';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'sub_title_en', 'sub_title_ar', 'description_en', 'description_ar', 'phone', 'website', 'email', 'facebook', 'twitter', 'instagram', 'linked_in', 'country_id', 'category_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}