<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('expiration_date')->nullable();
			$table->enum('status', array('active', 'expired'))->nullable();
			$table->integer('factory_id')->nullable();
			$table->string('image')->nullable();
			$table->string('link')->nullable();
			$table->text('location')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}