<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function access_tokens()
    {
        return $this->morphMany('App\AccessToken', 'tokenable');
    }

    public function likesToUsers()
    {
        return $this->belongsToMany('UserLike');
    }

    public function dislikesToUser()
    {
        return $this->belongsToMany('UserDislike');
    }

    public function interests()
    {
        return $this->belongsToMany('UserInterest');
    }

    public function participant()
    {
        return $this->belongsToMany('Participant');
    }

    public function rewards()
    {
        return $this->belongsToMany('UserRewards');
    }

}