<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsEventsTable extends Migration {

	public function up()
	{
		Schema::create('news_events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ne_title', 255)->nullable();
			$table->string('ne_description', 255)->nullable();
			$table->text('ne_image')->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->datetimeTz('post_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news_events');
	}
}