<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleryTable extends Migration {

	public function up()
	{
		Schema::create('gallery', function(Blueprint $table) {
			$table->increments('id');
			$table->string('video_url', 255)->nullable();
			$table->text('video_img')->nullable();
			$table->string('video_title', 255)->nullable();
			$table->text('image')->nullable();
			$table->string('image_title', 255)->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gallery');
	}
}