<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('services', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('pan_number', 255)->nullable();
			$table->string('aadhar_num', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('confirm_pass', 255)->nullable();
			$table->text('profile_img')->nullable();
			$table->text('resume')->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}