<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccreditationTable extends Migration {

	public function up()
	{
		Schema::create('accreditation', function(Blueprint $table) {
			$table->increments('id');
			$table->text('logo')->nullable();
			$table->string('title', 255)->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accreditation');
	}
}