<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('card_id')->references('id')->on('cards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('image')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_type')->references('id')->on('order_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('pro_cats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('pro_menus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('image')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pro_menus', function(Blueprint $table) {
			$table->foreign('banner')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pro_cats', function(Blueprint $table) {
			$table->foreign('banner')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outlates', function(Blueprint $table) {
			$table->foreign('banner')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('type')->references('id')->on('file_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pro_varations', function(Blueprint $table) {
			$table->foreign('pro_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_card_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_image_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_type_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_cat_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_menu_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_image_foreign');
		});
		Schema::table('pro_menus', function(Blueprint $table) {
			$table->dropForeign('pro_menus_banner_foreign');
		});
		Schema::table('pro_cats', function(Blueprint $table) {
			$table->dropForeign('pro_cats_banner_foreign');
		});
		Schema::table('outlates', function(Blueprint $table) {
			$table->dropForeign('outlates_banner_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_type_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('pro_varations', function(Blueprint $table) {
			$table->dropForeign('pro_varations_pro_id_foreign');
		});
	}
}