<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('fname', 225);
			$table->string('lname', 225);
			$table->string('email', 225);
			$table->string('phone', 40);
			$table->string('password');
			$table->integer('card_id')->unsigned()->default('0');
			$table->string('gender', 5)->default('male');
			$table->text('address');
			$table->integer('image')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}