<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('quantity');
			$table->double('total');
			$table->integer('order_type')->unsigned();
			$table->text('d_address');
			$table->float('d_charge');
			$table->datetime('date');
			$table->integer('pickup_store');
			$table->bigInteger('user_id')->unsigned();
			$table->float('gst_charge');
			$table->string('d_time', 30);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}