<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('checkout_id');
			$table->integer('office_associate_id')->unsigned();
			$table->bigInteger('user_id');
			$table->string('status');
			$table->integer('sub_total');
			$table->float('discount');
			$table->float('total');
			$table->string('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}