<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBasicDataTable extends Migration {

	public function up()
	{
		Schema::create('basic_data', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255);
			$table->decimal('amount', 8,2)->nullable();
			$table->enum('expense_type', array('judicial', 'sundries'));
			$table->string('type', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('basic_data');
	}
}