<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('enveloppe', function(Blueprint $table) {
			$table->foreign('id_subvention')->references('id_subvention')->on('subvention')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('plafond', function(Blueprint $table) {
			$table->foreign('id_subvention')->references('id_subvention')->on('subvention')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('critere', function(Blueprint $table) {
			$table->foreign('id_critere')->references('id_critere')->on('critere')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('critere', function(Blueprint $table) {
			$table->foreign('id_subvention')->references('id_subvention')->on('subvention')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('subvention_reapprovisionnement', function(Blueprint $table) {
			$table->foreign('id_subvention')->references('id_subvention')->on('subvention')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('critere_tranche', function(Blueprint $table) {
			$table->foreign('id_criterion')->references('id_critere')->on('critere')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('critere_selecion', function(Blueprint $table) {
			$table->foreign('id_critere')->references('id_critere')->on('critere')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('enveloppe_utilisateur_utilisation', function(Blueprint $table) {
			$table->foreign('id_enveloppe')->references('id_enveloppe')->on('enveloppe')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->foreign('id_enveloppe')->references('id_enveloppe')->on('enveloppe')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->foreign('id_plafond_somme')->references('id_plafond')->on('plafond')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->foreign('is_plafond_quantite')->references('id_plafond')->on('plafond')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('abonement_role', function(Blueprint $table) {
			$table->foreign('id_abonnment')->references('id_abonnment')->on('abonnment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('enveloppe', function(Blueprint $table) {
			$table->dropForeign('enveloppe_id_subvention_foreign');
		});
		Schema::table('plafond', function(Blueprint $table) {
			$table->dropForeign('plafond_id_subvention_foreign');
		});
		Schema::table('critere', function(Blueprint $table) {
			$table->dropForeign('critere_id_critere_foreign');
		});
		Schema::table('critere', function(Blueprint $table) {
			$table->dropForeign('critere_id_subvention_foreign');
		});
		Schema::table('subvention_reapprovisionnement', function(Blueprint $table) {
			$table->dropForeign('subvention_reapprovisionnement_id_subvention_foreign');
		});
		Schema::table('critere_tranche', function(Blueprint $table) {
			$table->dropForeign('critere_tranche_id_criterion_foreign');
		});
		Schema::table('critere_selecion', function(Blueprint $table) {
			$table->dropForeign('critere_selecion_id_critere_foreign');
		});
		Schema::table('enveloppe_utilisateur_utilisation', function(Blueprint $table) {
			$table->dropForeign('enveloppe_utilisateur_utilisation_id_enveloppe_foreign');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->dropForeign('ecpr_id_enveloppe_foreign');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->dropForeign('ecpr_id_plafond_somme_foreign');
		});
		Schema::table('ecpr', function(Blueprint $table) {
			$table->dropForeign('ecpr_is_plafond_quantite_foreign');
		});
		Schema::table('abonement_role', function(Blueprint $table) {
			$table->dropForeign('abonement_role_id_abonnment_foreign');
		});
	}
}