<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('mobile_no', 15)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('profile_photo')->nullable();
			$table->date('dob')->nullable();
			$table->string('status')->default('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}