<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentPaymentTable extends Migration {

	public function up()
	{
		Schema::create('student_payment', function(Blueprint $table) {
			$table->increments('id', true);
			$table->double('total_value');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('discount_id')->unsigned()->nullable();
			$table->integer('student_id')->unsigned();
			$table->enum('state', array('done', 'temp'));
		});
	}

	public function down()
	{
		Schema::drop('student_payment');
	}
}