<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->date('birthday_date');
			$table->enum('sexe', array('homme', 'femme'));
			$table->string('adresse');
			$table->string('zip_code');
			$table->string('ville');
			$table->string('password');
			$table->integer('countrie_id')->unsigned();
			$table->string('code');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}