<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('parent_id')->unsigned()->nullable()->index();
			$table->string('name');
			$table->text('description');
			$table->integer('sort_order')->nullable();
			$table->boolean('is_visible')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}